function is_islanded = check_islanding(mpc_fault)
%CHECK_ISLANDING 判断故障后电网是否存在孤岛效应
%   is_islanded = CHECK_ISLANDING(mpc_fault, gens) 返回逻辑值，表示
%   故障后电网是否被分割成多个孤立子网且这些子网中没有在线发电机。

    % 定义常量
    define_constants;
    % 仅选择状态为1的支路（活动支路）
    active_branches = mpc_fault.branch(:, BR_STATUS) == 1;
    
    % 创建图的连通性，仅使用活动支路
    g = graph(mpc_fault.branch(active_branches, F_BUS), mpc_fault.branch(active_branches, T_BUS));

    % 计算当前的连通分量数量
    connected_components = conncomp(g);

    
    % 如果存在多个连通分量，则认为存在孤岛效应
    if numel(unique(connected_components)) > 1
        is_islanded = true;
    else
        is_islanded = false;
    end

end
